/*
 * Created on 2004/02/23
 */
package org.CrystalMVP.PowderPlot;
import java.util.*;
import java.io.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.dnd.*;
/**
 * @author monazite
 */
public class PPWindow implements MouseListener, MouseMoveListener, KeyListener {
	PowderPlot window;
	Display display;
	Shell shell;
	Canvas canvas;
	Image bgImage;
	ImageData imdata;
	//Text text;
	byte[] pbuf;
	byte[][] color = new byte[4][4];
	GC gc;
	Label status;
	Button[] dispBtn = new Button[3];
	float ymin, ymax, scaleX = 1, scaleY = 1, xScale, yScale, do2th, doI;
	PowderData data1 = new PowderData();
	//float[][] originalData, peakPositionf;
	//float[] iTwoThetaFloat, iObsFloat, iCalcFloat, iDiffFloat;
	//int[] iTwoThetaInt, iObsInt, iCalcInt, iDiffInt;

	int[][] peakPositioni;
	int[] xPosition;
	byte[][][] indexes;
	int redMask, greenMask, blueMask, alphaMask;
	int doX,
		doY,
		SCREENW,
		SCREENH,
		offsetX = 0,
		offsetY = 0,
		dataOffset = 20,
		width,
		height,
		xZero = 70,
		yZero = 40,
		MODE = 0;
	boolean mouseDown, mouseMove = false, obs = true, calc = true, diff = true, pp = true;

	public PPWindow(PowderPlot wind, String str) {
		window = wind;
		display = wind.display;
		shell = new Shell(display);
		shell.setText("PowderPlot");
		shell.setSize(800, 600);

		//shell.setLayout (new RowLayout (SWT.VERTICAL));

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1; // Composite を置いたため、2 -> 1 に変更しました
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.horizontalSpacing = 0;
		gridLayout.verticalSpacing = 0;
		shell.setLayout(gridLayout);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		shell.setLayoutData(gridData);

		//----------------------------------------------------------
		//Menu Bar
		//----------------------------------------------------------
		Menu menu = new Menu(shell, SWT.BAR);
		MenuItem item1 = new MenuItem(menu, SWT.CASCADE);
		item1.setAccelerator('f');
		item1.setText("File (F)");

		Menu menu1 = new Menu(item1);
		item1.setMenu(menu1);
		MenuItem item1_2 = new MenuItem(menu1, SWT.PUSH);
		item1_2.setAccelerator('o' | SWT.CONTROL);
		item1_2.setText("Open	Ctrl+O");
		item1_2.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				openDialog();
			}
		});
		MenuItem item1_3 = new MenuItem(menu1, SWT.PUSH);
		item1_3.setAccelerator('n' | SWT.CONTROL);
		item1_3.setText("New window	Ctrl+N");
		item1_3.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				window.createNewWindow();
				//NewWindow window = new NewWindow();
				//display.asyncExec(new NewWindow());
			}
		});
		//MenuItem bar1_2 = new MenuItem(menu1, SWT.BAR);
		MenuItem item1_5 = new MenuItem(menu1, SWT.PUSH);
		item1_5.setAccelerator('w' | SWT.CONTROL);
		item1_5.setText("Exit	Ctrl+W");
		item1_5.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				shell.dispose();
			}
		});

		//----------------------------------------------------------
		//GUI Bar
		//----------------------------------------------------------
		Composite compPanel = new Composite(shell, SWT.NULL);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		//gridData.horizontalSpan = 4;
		compPanel.setLayoutData(gridData);

		gridLayout = new GridLayout();
		gridLayout.numColumns = 4;
		gridLayout.marginHeight = 2;
		gridLayout.marginWidth = 2;
		gridLayout.horizontalSpacing = 4;
		gridLayout.verticalSpacing = 0;
		compPanel.setLayout(gridLayout);

		mModeEvent mevent = new mModeEvent();
		dispBtn[0] = new Button(compPanel, SWT.CHECK);
		dispBtn[0].setText("I(obs)");
		dispBtn[0].setSelection(true);
		dispBtn[0].addSelectionListener(mevent);

		dispBtn[1] = new Button(compPanel, SWT.CHECK);
		dispBtn[1].setText("I(calc)");
		dispBtn[1].setSelection(true);
		dispBtn[1].addSelectionListener(mevent);

		dispBtn[2] = new Button(compPanel, SWT.CHECK);
		dispBtn[2].setText("I(obs) - I(calc)");
		dispBtn[2].setSelection(true);
		dispBtn[2].addSelectionListener(mevent);

		Button mouseBtn = new Button(compPanel, SWT.TOGGLE);
		mouseBtn.setText("MOVE");
		mouseBtn.addSelectionListener(mevent);

		//----------------------------------------------------------
		//Canvas
		//----------------------------------------------------------
		canvas = new Canvas(shell, SWT.BORDER);
		gridData = new GridData(GridData.FILL_BOTH);
		canvas.setLayoutData(gridData);

		canvas.addMouseListener(this);
		canvas.addMouseMoveListener(this);
		canvas.addKeyListener(this);
		canvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				redraw();
			}
		});
		gc = new GC(canvas);

		//----------------------------------------------------------
		//Set Color
		//----------------------------------------------------------
		Image img = new Image(display, new Rectangle(0, 0, 2, 2));
		ImageData imd = img.getImageData();
		redMask = imd.palette.redMask;
		greenMask = imd.palette.greenMask;
		blueMask = imd.palette.blueMask;
		alphaMask = 0xffffffff - (redMask | greenMask | blueMask);
		img.dispose();
		int temCl = alphaMask;
		color[0][0] = (byte) ((temCl & 0xff000000) >> 24);
		color[0][1] = (byte) ((temCl & 0x00ff0000) >> 16);
		color[0][2] = (byte) ((temCl & 0x0000ff00) >> 8);
		color[0][3] = (byte) (temCl & 0x000000ff);

		temCl = redMask | alphaMask;
		color[1][0] = (byte) ((temCl & 0xff000000) >> 24);
		color[1][1] = (byte) ((temCl & 0x00ff0000) >> 16);
		color[1][2] = (byte) ((temCl & 0x0000ff00) >> 8);
		color[1][3] = (byte) (temCl & 0x000000ff);

		temCl = blueMask | alphaMask;
		color[2][0] = (byte) ((temCl & 0xff000000) >> 24);
		color[2][1] = (byte) ((temCl & 0x00ff0000) >> 16);
		color[2][2] = (byte) ((temCl & 0x0000ff00) >> 8);
		color[2][3] = (byte) (temCl & 0x000000ff);

		temCl = greenMask | alphaMask;
		color[3][0] = (byte) ((temCl & 0xff000000) >> 24);
		color[3][1] = (byte) ((temCl & 0x00ff0000) >> 16);
		color[3][2] = (byte) ((temCl & 0x0000ff00) >> 8);
		color[3][3] = (byte) (temCl & 0x000000ff);

		//----------------------------------------------------------
		//Support DnD
		//----------------------------------------------------------
		DropTarget target = new DropTarget(canvas, DND.DROP_DEFAULT | DND.DROP_COPY | DND.DROP_MOVE | DND.DROP_LINK);
		FileTransfer fileTransfer = FileTransfer.getInstance();
		Transfer[] types = new Transfer[] { fileTransfer };
		target.setTransfer(types);
		target.addDropListener(new DropTargetAdapter() {
			public void drop(DropTargetEvent e) {
				String[] files = (String[]) e.data;
				open(files[0]); // ファイルを開く
			}
		});

		//----------------------------------------------------------
		//Status Bar
		//----------------------------------------------------------
		Composite compoSt = new Composite(shell, SWT.BORDER);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		//gridData.horizontalSpan = 2;
		compoSt.setLayoutData(gridData);

		gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.marginHeight = 2;
		gridLayout.marginWidth = 2;
		gridLayout.horizontalSpacing = 4;
		gridLayout.verticalSpacing = 0;
		compoSt.setLayout(gridLayout);

		status = new Label(compoSt, SWT.NULL);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		status.setLayoutData(gridData);
		status.setText("status bar");

		shell.setMenuBar(menu); // メニューを窓に貼り付ける
		shell.layout();
		shell.open();

		if (str != null)
			open(str);
		// 窓が閉じるまでメインスレッドを終了しない
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		if (bgImage != null)
			bgImage.dispose();
		//if(window.isDisposed())
		window.dispose();
	}

	private void openDialog() {
		FileDialog openDialog = new FileDialog(shell, SWT.OPEN);
		openDialog.setFilterExtensions(new String[] { "*.itx", "*.pat", "*.int", "*.ptn", "*.txt", "*.*" });
		String openFile = openDialog.open();
		if (openFile == null)
			return;
		open(openFile);
	}

	private void open(String openFile) {
		StringTokenizer pm = new StringTokenizer(openFile, ".");
		String str = null;
		while (pm.hasMoreTokens()) {
			str = pm.nextToken();
		}
		if (str.equalsIgnoreCase("int"))
			readInt(openFile, " \t\n\r\f");
		else if (str.equalsIgnoreCase("csv"))
			readInt(openFile, ",");
		else if (str.equalsIgnoreCase("pat") || str.equalsIgnoreCase("itx"))
			readIgor(openFile);
		else if (str.equalsIgnoreCase("ptn"))
			readPtn(openFile, ", \t\n\r\f");
		else {
			try {
				readInt(openFile, ", \t\n\r\f");
			} catch (Exception e) {
				MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
				mes.setText("Error");
				mes.setMessage("Failed to read file.\n\nThis file type is not supported.");
				mes.open();
				return;
			}
		}
	}

	private void readIgor(String fileName) {
		try {
			FileReader fr = new FileReader(fileName);
			BufferedReader buf = new BufferedReader(fr);
			StringTokenizer pm;
			Vector powderData = new Vector();
			String str;
			if (!(str = buf.readLine()).equals("IGOR")) {
				buf.close();
				readGnuPlot(fileName);
				return;
			}

			buf.readLine();
			buf.readLine();
			ymax = 0;
			ymin = 0;
			buf.mark(50);
			int tocdp = 0; //twoTheta, Iobs, Icalc, Idiff, PeakPosition
			if ((str = buf.readLine()) != null) {
				pm = new StringTokenizer(str);
				tocdp = pm.countTokens();

				if (tocdp == 2) {
					obs = false;
					calc = true;
					diff = false;
					dispBtn[0].setEnabled(false);
					dispBtn[1].setEnabled(true);
					dispBtn[2].setEnabled(false);
				} else if (tocdp >= 4) {
					obs = true;
					calc = true;
					diff = true;
					dispBtn[0].setEnabled(true);
					dispBtn[1].setEnabled(true);
					dispBtn[2].setEnabled(true);
				}

			}
			buf.reset();
			while (!(str = buf.readLine()).equals("END")) {
				//System.out.println(str);
				pm = new StringTokenizer(str);
				float[] d = new float[5];
				if (pm.hasMoreTokens())
					d[0] = Float.parseFloat(pm.nextToken());
				if (pm.hasMoreTokens() && tocdp > 2) {
					d[1] = Float.parseFloat(pm.nextToken());
					if (ymax < d[1])
						ymax = d[1];
				}
				if (pm.hasMoreTokens())
					d[2] = Float.parseFloat(pm.nextToken());
				if (ymax < d[2])
					ymax = d[2];
				if (pm.hasMoreTokens())
					d[3] = Float.parseFloat(pm.nextToken());
				if (ymin > d[3])
					ymin = d[3];
				//d[4] = Float.parseFloat(pm.nextToken());
				powderData.addElement(d);
			}
			data1.originalData = new float[powderData.size()][5];
			data1.data = new int[powderData.size()][5];
			powderData.copyInto(data1.originalData);

			Vector peakData = new Vector();
			Vector indexData = new Vector();
			while (true) {
				while ((str = buf.readLine()) !=null){
					pm = new StringTokenizer(str, " ");
					if ((pm.nextToken().equals("WAVES/O"))) break;
				}
				if(str == null) break;
				buf.readLine();
				Vector peak = new Vector();
				while (!(str = buf.readLine()).equals("END")) {
					float f[] = new float[2];
					pm = new StringTokenizer(str, " ");
					f[0] = (Float.parseFloat(pm.nextToken()));
					pm.nextToken();
					pm.nextToken();
					f[1] = (Float.parseFloat(pm.nextToken()));
					//System.out.println("" + f);
					peak.addElement(f);
				}
				if(peak.size() > 0){
					float[][] p1 = new float[peak.size()][];
					for (int i = 0; i < p1.length; i++) {
						p1[i] = (float[]) peak.get(i);
					}
					//System.out.println(p1.length);
					peakData.addElement(p1);
					peak.clear();
				}

				//buf.readLine();
				while ((str = buf.readLine()) !=null && ! str.equals("BEGIN")){
				}
				if(str == null) break;
				while (!(str = buf.readLine()).equals("END")) {
					pm = new StringTokenizer(str, " ");
					byte[] bb = new byte[3];
					bb[0] = Byte.parseByte(pm.nextToken());
					bb[1] = Byte.parseByte(pm.nextToken());
					bb[2] = Byte.parseByte(pm.nextToken());
					//System.out.println(bb[0] + " " + bb[1] + " " + bb[2]);
					peak.addElement(bb);
				}
				buf.readLine();
				buf.readLine();
				byte[][] ibb = new byte[peak.size()][3];
				peak.copyInto(ibb);
				indexData.addElement(ibb);
			}
			data1.peakPositionf = new float[peakData.size()][][];
			peakPositioni = new int[peakData.size()][];
			indexes = new byte[indexData.size()][][];
			for (int i = 0; i < data1.peakPositionf.length; i++) {
				//peakPosition[i] = new float[1];
				data1.peakPositionf[i] = (float[][]) peakData.get(i);
				peakPositioni[i] = new int[data1.peakPositionf[i].length];
				indexes[i] = (byte[][]) indexData.get(i);
			}
			buf.close();
			dataOffset = 20 + 10 * data1.peakPositionf.length;
			scaleX = 1;
			scaleY = 1;
			offsetX = 0;
			offsetY = 0;
			status.setText("data1.data point: " + data1.data.length);

			char pathToken = File.separatorChar;
			pm = new StringTokenizer(fileName, "" + pathToken);
			while (pm.hasMoreTokens()) {
				str = pm.nextToken();
			}
			shell.setText(str + " - PowderPlot");
		} catch (IOException e) {
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Fatal Error\n\nFailed to read file.");
			mes.open();
			return;
		}
		//System.out.println("data1.data length = "+ data1.data.length);
		redraw();
	}

	private void readGnuPlot(String fileName) {
		try {
			FileReader fr = new FileReader(fileName);
			BufferedReader buf = new BufferedReader(fr);
			StringTokenizer pm;
			Vector powderData = new Vector();
			String str;
			ymax = 0;
			ymin = 0;

			buf.mark(50);
			int tocdp = 0; //twoTheta, Iobs, Icalc, Idiff, PeakPosition
			if ((str = buf.readLine()) != null) {
				pm = new StringTokenizer(str);
				tocdp = pm.countTokens();

				if (tocdp == 2) {
					obs = false;
					calc = true;
					diff = false;
					dispBtn[0].setEnabled(false);
					dispBtn[1].setEnabled(true);
					dispBtn[2].setEnabled(false);
				} else if (tocdp >= 4) {
					obs = true;
					calc = true;
					diff = true;
					dispBtn[0].setEnabled(true);
					dispBtn[1].setEnabled(true);
					dispBtn[2].setEnabled(true);
				}

			}
			buf.reset();

			while ((str = buf.readLine()) != null) {
				if (str.length() == 0)
					continue;
				pm = new StringTokenizer(str);
				if (!pm.hasMoreTokens())
					continue;
				float[] d = new float[5];
				if (pm.hasMoreTokens())
					d[0] = Float.parseFloat(pm.nextToken());
				if (pm.hasMoreTokens() && tocdp > 2) {
					d[1] = Float.parseFloat(pm.nextToken());
					if (ymax < d[1])
						ymax = d[1];
				}
				if (pm.hasMoreTokens()) {
					d[2] = Float.parseFloat(pm.nextToken());
					if (ymax < d[2])
						ymax = d[2];
					d[3] = d[1] - d[2];
					if (ymin > d[3])
						ymin = d[3];
				}
				//d[4] = Float.parseFloat(pm.nextToken());
				powderData.addElement(d);
			}
			data1.originalData = new float[powderData.size()][5];
			data1.data = new int[powderData.size()][5];
			powderData.copyInto(data1.originalData);
			buf.close();
			data1.peakPositionf = null;
			peakPositioni = null;
			scaleX = 1;
			scaleY = 1;
			offsetX = 0;
			offsetY = 0;
			status.setText("data1.data point: " + data1.data.length);

			char pathToken = File.separatorChar;
			pm = new StringTokenizer(fileName, "" + pathToken);
			while (pm.hasMoreTokens()) {
				str = pm.nextToken();
			}
			shell.setText(str + " - PowderPlot");
		} catch (IOException e) {
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Fatal Error\n\nFailed to read file.");
			mes.open();
			return;
		}
		redraw();
	}

	private void readInt(String fileName, String token) {
		try {
			FileReader fr = new FileReader(fileName);
			BufferedReader buf = new BufferedReader(fr);
			StringTokenizer pm;
			Vector powderData = new Vector();
			String str;
			ymax = 0;
			ymin = 0;

			buf.mark(50);
			if ((str = buf.readLine()).matches("GENERAL*.")) {
				buf.readLine();
			}else if(str.equals("IGOR")){
				token = "	";
				buf.readLine();
				buf.readLine();
			}else buf.reset();

			while ((str = buf.readLine()) != null && !str.matches(".*f") && !str.equals("END")) {
				pm = new StringTokenizer(str, token);
				float[] d = new float[5];
				if (pm.hasMoreTokens())
					d[0] = Float.parseFloat(pm.nextToken());
				if (pm.hasMoreTokens()) {
					d[1] = Float.parseFloat(pm.nextToken());
					if (ymax < d[1])
						ymax = d[1];
				}
				if (pm.hasMoreTokens())
					d[2] = Float.parseFloat(pm.nextToken());
				if (ymax < d[2])
					ymax = d[2];
				if (pm.hasMoreTokens())
					d[3] = Float.parseFloat(pm.nextToken());
				if (ymin > d[3])
					ymin = d[3];
				//d[4] = Float.parseFloat(pm.nextToken());
				powderData.addElement(d);
			}
			data1.originalData = new float[powderData.size()][5];
			data1.data = new int[powderData.size()][5];
			powderData.copyInto(data1.originalData);
			buf.close();
			data1.peakPositionf = null;
			peakPositioni = null;
			scaleX = 1;
			scaleY = 1;
			offsetX = 0;
			offsetY = 0;
			status.setText("data1.data point: " + data1.data.length);

			char pathToken = File.separatorChar;
			pm = new StringTokenizer(fileName, "" + pathToken);
			while (pm.hasMoreTokens()) {
				str = pm.nextToken();
			}
			shell.setText(str + " - PowderPlot");
			obs = true;
			calc = false;
			diff = false;
			dispBtn[0].setEnabled(true);
			dispBtn[1].setEnabled(false);
			dispBtn[2].setEnabled(false);
		} catch (IOException e) {
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Fatal Error\n\nFailed to read file.");
			mes.open();
			return;
		} catch (NumberFormatException e) {
			e.printStackTrace();
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Failed to read file.\n\nThis file format is not supported yet.");
			mes.open();
		}
		redraw();
	}

	private void readPtn(String fileName, String token) {
		try {
			FileReader fr = new FileReader(fileName);
			BufferedReader buf = new BufferedReader(fr);
			StringTokenizer pm;
			Vector powderData = new Vector();
			String str = "";
			float xmin=0, inc=0.02f;
			ymax = 0;
			ymin = 0;
			
			buf.mark(50);
			for(int i=0; i<13; i++){
				str = buf.readLine();
			}
			pm = new StringTokenizer(str, token);
			if (pm.hasMoreTokens()) Float.parseFloat(pm.nextToken());
			if (pm.hasMoreTokens()) xmin = Float.parseFloat(pm.nextToken());
			if (pm.hasMoreTokens()) Float.parseFloat(pm.nextToken());
			if (pm.hasMoreTokens()) inc  = Float.parseFloat(pm.nextToken());

			int i = 0;
			while ((str = buf.readLine()) != null) {
				pm = new StringTokenizer(str, token);
				float[] d = new float[5];
				if (pm.hasMoreTokens()){
					d[0] = xmin + inc * i;
					d[1] = Float.parseFloat(pm.nextToken());
					if (ymax < d[1])
						ymax = d[1];
					if (ymin > d[1])
						ymin = d[1];
				}
				i++;
				//d[4] = Float.parseFloat(pm.nextToken());
				powderData.addElement(d);
			}
			data1.originalData = new float[powderData.size()][5];
			data1.data = new int[powderData.size()][5];
			powderData.copyInto(data1.originalData);
			buf.close();
			data1.peakPositionf = null;
			peakPositioni = null;
			scaleX = 1;
			scaleY = 1;
			offsetX = 0;
			offsetY = 0;
			status.setText("data1.data point: " + data1.data.length);

			char pathToken = File.separatorChar;
			pm = new StringTokenizer(fileName, "" + pathToken);
			while (pm.hasMoreTokens()) {
				str = pm.nextToken();
			}
			shell.setText(str + " - PowderPlot");
			obs = true;
			calc = false;
			diff = false;
			dispBtn[0].setEnabled(true);
			dispBtn[1].setEnabled(false);
			dispBtn[2].setEnabled(false);
		} catch (IOException e) {
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Fatal Error\n\nFailed to read file.");
			mes.open();
			return;
		} catch (NumberFormatException e) {
			e.printStackTrace();
			MessageBox mes = new MessageBox(shell, SWT.ICON_ERROR);
			mes.setText("Error");
			mes.setMessage("Failed to read file.\n\nThis file format is not supported yet.");
			mes.open();
		}
		redraw();
	}

	private void redraw() {
		SCREENW = canvas.getClientArea().width;
		SCREENH = canvas.getClientArea().height;
		xPosition = new int[SCREENW+1];
		//Image imgTmp = new Image(display, canvas.getClientArea());
		//imdata = imgTmp.getImageData();
		//imgTmp.dispose();
		imdata = new ImageData(SCREENW, SCREENH, 32, new PaletteData(redMask, greenMask, blueMask));
		pbuf = imdata.data;
		int oldWidth = width;
		int oldHeight = height;
		width = canvas.getClientArea().width - xZero;
		height = canvas.getClientArea().height - yZero;

		if (oldWidth > 0 && oldHeight > 0) {
			offsetX = offsetX * width / oldWidth;
			offsetY = offsetY * height / oldHeight;
		}

		if (data1.data == null || data1.data.length == 0) return;
		//float twoTheta = data1.originalData[data1.originalData.length - 1][0];
		//float yScale = (height - dataOffset) / (ymax - ymin) * scaleY;
		//float xScale = width / twoTheta * scaleX;

		repaint2();
	}

	private void repaint2() {
		for (int i = 0; i < pbuf.length; i++) {
			pbuf[i] = -1;
		}
		for (int i=0; i<xPosition.length; i++){
			xPosition[i] = -1;
		}
		float twoTheta = data1.originalData[data1.originalData.length - 1][0];
		yScale = (height - dataOffset) / (ymax - ymin) * scaleY;
		xScale = width / twoTheta * scaleX;
		int I1 = 0, I2 = data1.originalData.length;

		for (int i = 0; i < data1.originalData.length; i++) {
			if (data1.originalData[i][0] > offsetX / xScale) {
				I1 = i;
				if (I1 > 0)
					I1 = I1 - 1;
				break;
			}
		}

		for (int i = I1; i < data1.originalData.length; i++) {
			data1.data[i][0] = (int) (data1.originalData[i][0] * xScale) - offsetX + xZero;
			if (data1.data[i][0] >= xZero + width) {
				I2 = i + 1;
				break;
			}
		}
		if (obs) {
			for (int i = I1; i < I2; i++) {
				//if(!(data1.data[i][0] >= xZero && data1.data[i][0] <= xZero + width)) continue;
				data1.data[i][1] = height - (int) ((data1.originalData[i][1] - ymin) * yScale) + offsetY - dataOffset;
				drawLine(data1.data[i][0], data1.data[i][1] - 2, data1.data[i][0], data1.data[i][1] + 2, color[0]);
				drawLine(data1.data[i][0] - 2, data1.data[i][1], data1.data[i][0] + 2, data1.data[i][1], color[0]);
			}
		}
		if (calc) {
			data1.data[I1][2] = height - (int) ((data1.originalData[0][2] - ymin) * yScale) + offsetY - dataOffset;
			for (int i = I1 + 1; i < I2; i++) {
				data1.data[i][2] = height - (int) ((data1.originalData[i][2] - ymin) * yScale) + offsetY - dataOffset;
				//if(!(data1.data[i][0] >= xZero && data1.data[i][0] <= xZero + width)) continue;
				drawLine(data1.data[i - 1][0], data1.data[i - 1][2], data1.data[i][0], data1.data[i][2], color[1]);
			}
		}
		if (diff) {
			data1.data[I1][3] = height - (int) ((data1.originalData[0][3] - ymin) * yScale) + offsetY;
			for (int i = I1 + 1; i < I2; i++) {
				data1.data[i][3] = height - (int) ((data1.originalData[i][3] - ymin) * yScale) + offsetY;
				//if(!(data1.data[i][0] >= xZero && data1.data[i][0] <= xZero + width)) continue;
				drawLine(data1.data[i - 1][0], data1.data[i - 1][3], data1.data[i][0], data1.data[i][3], color[2]);
			}
		}
		if (pp && peakPositioni != null) {
			for (int i = 0; i < data1.peakPositionf.length; i++) {
				int y = height - dataOffset + 10 * (i + 1) + (int) (ymin * (height - dataOffset) / (ymax - ymin));
				for (int j = 0; j < data1.peakPositionf[i].length; j++) {
					peakPositioni[i][j] = (int) (data1.peakPositionf[i][j][0] * xScale) - offsetX + xZero;
					if (!(peakPositioni[i][j] >= xZero && peakPositioni[i][j] <= xZero + width))
						continue;
					xPosition[peakPositioni[i][j]] = (i << 16) | j + 1;
					drawLine(peakPositioni[i][j], y, peakPositioni[i][j], y + 8, color[3]);
				}
			}
		}
		if (bgImage != null)
			bgImage.dispose();
		bgImage = new Image(display, imdata);
		GC gcB = new GC(bgImage);
		int averageCharWidth = gcB.getAdvanceWidth('8');
		float[] a = { 100, 50, 25, 10, 5, 2.5f, 1, 0.5f, 0.25f, 0.1f};
		long memori = 1;
		gcB.setForeground(new Color(null, 0, 0, 0));
		gcB.drawRectangle(xZero, 0, width, height);
		for (int i = 5; i >= -3; i--) {
			for (int j = 0; j < a.length; j++) {
				float x = (float) (Math.pow(10, i) * a[j]);
				if (twoTheta / scaleX / x < 11) {
					memori = (int) (x * 10000);
				}
			}
		}
		//gcB.setForeground(new Color(null,0,0,0));
		for (int i = 0; 1.0 * i * memori/10000 < data1.originalData[data1.data.length - 1][0]; i++) {
			int xstart = (int) (i * memori * xScale / 10000 - offsetX + xZero);
			if (xstart >= xZero && xstart <= xZero + width) {
				gcB.drawLine(xstart, height - 5, xstart, height);
				if((memori%10000) == 0)gcB.drawString("" + i * memori/10000, xstart - 5, height + 8, true);
				else gcB.drawString("" + 1.0f * i * memori/10000, xstart - 5, height + 8, true);
			}
		}
		for (int i = 5; i >= -3; i--) {
			for (int j = 0; j < a.length; j++) {
				double y = (double) (Math.pow(10, i) * a[j]);
				if (ymax / scaleY / y < 11) {
					memori = (long)(y*1000);
				}
			}
		}
		for (int i = 0; 1.0*i*memori/1000 < ymax; i++) {
			int ystart = (int) (height - (1.0 * i * memori/1000 - ymin) * yScale + offsetY - dataOffset);
			if (ystart <= height && ystart >= 0) {
				gcB.drawLine(xZero, ystart, xZero + 5, ystart);
				String intensityStr;
				if((memori%1000) == 0) intensityStr = "" + i * memori/1000;
				else intensityStr = "" + 1.0 * i * memori/1000;
				int xxx = averageCharWidth * (intensityStr.length() + 1);
				gcB.drawString(intensityStr, xZero - xxx, ystart - 5, true);
			}
		}
		gc.drawImage(bgImage, 0, 0);
		gcB.dispose();
	}

	//----------------------------------------------------------
	//Mouse Event
	//----------------------------------------------------------
	public void mouseUp(MouseEvent e) {
		if (mouseDown == false || mouseMove == false) {
			mouseDown = false;
			mouseMove = false;
			return;
		}
		int x = e.x;
		int y = e.y;
		int xx = doX, yy = y;
		if (x < doX)
			xx = x;
		if (y < doY)
			yy = doY;
		if (MODE == 1) {
			offsetX = (offsetX + (doX - x));
			offsetY = (offsetY + (y - doY));
		} else {
			try {
				scaleX = scaleX * width / Math.abs(x - doX);
				scaleY = scaleY * height / Math.abs(y - doY);
				offsetX = (offsetX + xx - xZero) * width / Math.abs(x - doX);
				offsetY =
					(offsetY + (canvas.getClientArea().height - yy - dataOffset) - yZero) * height / Math.abs(y - doY);
			} catch (ArithmeticException ae) {
				//scaleX=1;
				//scaleY=1;
			}
		}

		mouseDown = false;
		mouseMove = false;
		if(data1.originalData != null)repaint2();
		status.setText(scaleX + ", " + scaleY);
	}
	public void mouseDown(MouseEvent e) {
		mouseDown = true;
		doX = e.x;
		doY = e.y;
		if(indexes == null || xPosition == null) return;
		do2th = (doX + offsetX - xZero) / xScale;
		doI = (int)((-doY + height + offsetY - dataOffset) / yScale + ymin);
		//offsetX = (offsetX + doX);
		//offsetY = (offsetY + doY);
		//redraw();
	}
	public void mouseDoubleClick(MouseEvent e) {
		scaleX = 1;
		scaleY = 1;
		offsetX = 0;
		offsetY = 0;
		if(data1.originalData != null){
			status.setText("data1.data point: " + data1.data.length);
			repaint2();
		}
		mouseDown = false;
	}
	public void mouseMove(MouseEvent e) {
		int x = e.x;
		int y = e.y;

		float X = (x + offsetX - xZero) / xScale;
		int Y = (int)((-y + height + offsetY - dataOffset) / yScale + ymin);
		if(indexes != null && xPosition != null) {
		if(x < xPosition.length && xPosition[x] > 0){
			xPosition[0] = -2;
			gc.drawImage(bgImage, 0, 0);
			int i = ((xPosition[x]-1) & 0xffff0000) >> 16;
			int j = (xPosition[x] - 1) & 0xffff;
			//int yP = height - dataOffset + 10 * (i + 1) + (int) (ymin * (height - dataOffset) / (ymax - ymin));
			gc.drawString("phase"+ (i+1) +", "+indexes[i][j][0] + " " + indexes[i][j][1] + " " + indexes[i][j][2] +
					"; d=" + data1.peakPositionf[i][j][1] + " A", x, y-16);
		}else if(xPosition[0] == -2){
			xPosition[0] = -1;
			gc.drawImage(bgImage, 0, 0);
		}
		}
		if (!mouseDown){
			status.setText(X + ", " + Y);
			return;
		}

		mouseMove = true;

		gc.setForeground(new Color(null, 0, 0, 0));
		if (MODE == 0 && bgImage != null) {
			gc.drawImage(bgImage, 0, 0);
			gc.drawRectangle(doX, doY, x - doX, y - doY);
		} else if (MODE == 1 && bgImage != null) {
			gc.drawImage(bgImage, x - doX, y - doY);
			gc.drawRectangle(xZero, 0, width, height);
		}
		status.setText(do2th + ", " + doI + "; " + X + ", " + Y);
	}

	public void keyPressed(KeyEvent e) {
		char a = e.character;
		//mouseDown = false;
		//mouseMove = false;
		switch (a) {
			case '+' :
				scaleX *= 1.1f;
				scaleY *= 1.1f;
				redraw();
				break;
			case '-' :
				scaleX *= 0.9f;
				scaleY *= 0.9f;
				redraw();
				break;
		}
		if (e.keyCode == SWT.ARROW_RIGHT) {
			if (e.stateMask == SWT.SHIFT) {
				scaleX = scaleX * 1.111f;
				offsetX = (int) (offsetX * 1.111);
			} else
				offsetX = offsetX - 10;
			repaint2();
		} else if (e.keyCode == SWT.ARROW_LEFT) {
			if (e.stateMask == SWT.SHIFT) {
				scaleX = scaleX * 0.9f;
				offsetX = (int) (offsetX * 0.9);
			} else
				offsetX = offsetX + 10;
			repaint2();
		} else if (e.keyCode == SWT.ARROW_UP) {
			if (e.stateMask == SWT.SHIFT) {
				scaleY = scaleY * 1.111f;
				offsetY = (int) (offsetY * 1.111);
			} else
				offsetY = offsetY - 10;
			repaint2();
		} else if (e.keyCode == SWT.ARROW_DOWN) {
			if (e.stateMask == SWT.SHIFT) {
				scaleY = scaleY * 0.9f;
				offsetY = (int) (offsetY * 0.9);
			} else
				offsetY = offsetY + 10;
			repaint2();
		} else if (e.keyCode == SWT.ESC) {
			mouseDown = false;
			repaint2();
		}
		//status.setText(""+ e.keyCode);
	}
	public void keyReleased(KeyEvent e) {
	}

	private void drawLine(int x1, int y1, int x2, int y2, byte[] cl) {
		int x, y, ax, ay, px, py, p1;
		int lx = (int) Math.abs(x1 - x2);
		int ly = (int) Math.abs(y1 - y2);
		if (lx < ly) {
			ax = ((x2 - x1) * 0xffff / ly);
			ay = ((y2 - y1) / ly);
			x = x1 * 0xffff;
			y = y1;
			for (int i = 0; i <= ly; i++, x += ax, y += ay) {
				px = x / 0xffff;
				py = y;
				if (py >= 0 && py < height && px < SCREENW && px >= xZero) {
					p1 = py * SCREENW + px;
					pbuf[4 * p1] = cl[0];
					pbuf[4 * p1 + 1] = cl[1];
					pbuf[4 * p1 + 2] = cl[2];
					pbuf[4 * p1 + 3] = cl[3];
				}
			}
		} else if (lx == 0) {
			px = x1;
			py = y1;
			if (py >= 0 && py < height && px < SCREENW && px >= xZero) {
				p1 = py * SCREENW + px;
				pbuf[4 * p1] = cl[0];
				pbuf[4 * p1 + 1] = cl[1];
				pbuf[4 * p1 + 2] = cl[2];
				pbuf[4 * p1 + 3] = cl[3];
			}
		} else {
			ax = ((x2 - x1) / lx);
			ay = ((y2 - y1) * 0xffff / lx);
			x = x1;
			y = y1 * 0xffff;
			for (int i = 0; i <= lx; i++, x += ax, y += ay) {
				px = x;
				py = y / 0xffff;
				if (py >= 0 && py < height && px < SCREENW && px >= xZero) {
					p1 = py * SCREENW + px;
					pbuf[4 * p1] = cl[0];
					pbuf[4 * p1 + 1] = cl[1];
					pbuf[4 * p1 + 2] = cl[2];
					pbuf[4 * p1 + 3] = cl[3];
				}
			}
		}
	}

	private class mModeEvent implements SelectionListener {
		public mModeEvent() {
		}
		public void widgetDefaultSelected(SelectionEvent e) {
		}
		public void widgetSelected(SelectionEvent e) {
			Button btn = (Button) e.widget;
			if (btn == dispBtn[0]) {
				if (btn.getSelection())
					obs = true;
				else
					obs = false;
				redraw();
			} else if (btn == dispBtn[1]) {
				if (btn.getSelection())
					calc = true;
				else
					calc = false;
				redraw();
			} else if (btn == dispBtn[2]) {
				if (btn.getSelection())
					diff = true;
				else
					diff = false;
				redraw();
			} else if (btn.getSelection())
				MODE = 1;
			else
				MODE = 0;
		}
	}
}
